
//                            \/
// Knowledge of the ancients ( )
//______________________o0o___(_)___o0o______
//___Xard777________________GOD_OF_PIP$_ 

//......................//)
//....................,/../
//.................../..../
//.............//'...'/`
//........../'/.../..../......./\
//........('(.......... ~/'...')
//.........\.................'...../
//..........''...\.......... _.
//............\..............(
//..............\.............\...

#property indicator_chart_window
#property indicator_buffers 7

#property indicator_color1  Black
#property indicator_color2  C'48,160,96'
#property indicator_color3  C'150,50,70'
#property indicator_color4  C'150,50,70'
#property indicator_color5  C'20,20,20'
#property indicator_color6  Black
#property indicator_color7  Orange

#property indicator_width1  16
#property indicator_width2  14
#property indicator_width3  14
#property indicator_width4  14
#property indicator_width5  2
#property indicator_width6  5
#property indicator_width7  3

       int    Length= 20; 
       int    pricelineMODE= MODE_LWMA, pricelineMA= 3,  pricelinePRICE= PRICE_WEIGHTED;
extern bool   alertsOn= false, alertsOnCurrent= false, alertsOnTrendChange= true, alertsMessage= true,
              alertsSound= false, alertsNotify= false, alertsEmail= false;

       double Middlebgd[], Middle[], MiddleI[], MiddleII[], Slope[], mirrorbgd[], mirrorline[], trend[], Yield=1.618;

int init() { string short_name; short_name= " X2 PRICE ZONE"; IndicatorShortName(short_name);
   IndicatorBuffers(8);
   SetIndexBuffer(0,Middlebgd);   SetIndexStyle(0, DRAW_LINE);
   SetIndexBuffer(1,Middle);      SetIndexStyle(1, DRAW_LINE);
   SetIndexBuffer(2,MiddleI);     SetIndexStyle(2, DRAW_LINE);
   SetIndexBuffer(3,MiddleII);    SetIndexStyle(3, DRAW_LINE);
   SetIndexBuffer(4,Slope);       SetIndexStyle(4, DRAW_LINE);
   SetIndexBuffer(5,mirrorbgd);   SetIndexStyle(5, DRAW_LINE);
   SetIndexBuffer(6,mirrorline);  SetIndexStyle(6, DRAW_LINE);
   SetIndexBuffer(7,trend);   
   
   switch(Period()) { case     1: Length= Length;  break;    
                      case     5: Length= Length;  break; 
                      case    15: Length= Length;  break; 
                      case    30: Length= Length;  break; 
                      case    60: Length= Length*Yield;  break;
                      case   240: Length= Length/Yield;  break; 
                      case  1440: Length= Length/Yield;  break; 
                      case 10080: Length= Length/Yield;  break; 
                      case 43200: Length= Length/Yield;  break; } 
   
   return(0); }
  
int deinit() { return(0); }

int start() { int counted_bars=IndicatorCounted();
      if (counted_bars<0) return(-1); if (counted_bars>0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);
         if (Slope[limit]==-1) CleanPoint(limit,MiddleI,MiddleII);
   
   for (int i = limit; i>=0; i--) {	
	  
	   double     CloseMA= iEma(Close[i],Length,i,0);
	            Middle[i]= iEma(CloseMA ,Length,i,3);
	         Middlebgd[i]= Middle[i];   
	        mirrorline[i]= 2* Middle[i]- iMA(NULL, 0, pricelineMA, 0, pricelineMODE, pricelinePRICE, i);
            mirrorbgd[i]= mirrorline[i];  
	             Slope[i]= Slope[i+1];
	           MiddleI[i]= EMPTY_VALUE;
	          MiddleII[i]= EMPTY_VALUE;
	          
                if (mirrorline[i] < Middle[i+1]) Slope[i] =  1;
                if (mirrorline[i] > Middle[i+1]) Slope[i] = -1;
                if (Slope[i] == -1) PlotPoint(i,MiddleI,MiddleII,Middle);
                trend[i] = 0; 
                                                     
   if (alertsOnTrendChange)       
   { if ( mirrorline[i]< Middle[i]) trend[i]= 1; if ( mirrorline[i]> Middle[i]) trend[i]=-1; } }
   
   manageAlerts(); return(0); }


double workEma[][4];
double iEma(double price, double period, int r, int instanceNo=0) {
   if (ArrayRange(workEma,0)!= Bars) ArrayResize(workEma,Bars); r = Bars-r-1;
   
   double alpha = 2.0 / (1.0+period);
          workEma[r][instanceNo] = workEma[r-1][instanceNo]+alpha*(price-workEma[r-1][instanceNo]);
   return(workEma[r][instanceNo]); }

void CleanPoint(int i,double& first[],double& second[]) {
   if ((second[i]!= EMPTY_VALUE)&& (second[i+1]!= EMPTY_VALUE)) second[i+1]= EMPTY_VALUE;
   else
   if ((first[i]!= EMPTY_VALUE)&& (first[i+1]!= EMPTY_VALUE) && (first[i+2]== EMPTY_VALUE))
        first[i+1]= EMPTY_VALUE; }

void PlotPoint(int i,double& first[],double& second[],double& from[]) {
   if (first[i+1]== EMPTY_VALUE) { 
   if (first[i+2]== EMPTY_VALUE) { 
       first[i]= from[i]; first[i+1]= from[i+1]; second[i]= EMPTY_VALUE; }
   else
      { second[i]= from[i]; second[i+1]=  from[i+1]; first[i]= EMPTY_VALUE; } }
   else
      { first[i]= from[i]; second[i]= EMPTY_VALUE; } }

void manageAlerts() {
   if (alertsOn) {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; 
      if (trend[whichBar] != trend[whichBar+1]) {
         if (trend[whichBar] == 1) doAlert(whichBar,"UP");
         if (trend[whichBar] ==-1) doAlert(whichBar,"DOWN"); } } }

void doAlert(int forBar, string doWhat) {
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Possible ",doWhat," Trend");
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(StringConcatenate(Symbol(), Period() ," Price Zone " +" "+message));
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Price Zone "),message);
          if (alertsSound)   PlaySound("alertz.wav"); } }
    
//--------------------------------------------Xard@hotmail.co.uk-----+
/*                                                                   
                              ud$$$**$$$$$$$bc.                          
                          u@**"        4$$$$$$$Nu                       
                        J                ""#$$$$$$r                     
                       @                       $$$$b                    
                     .F                        ^*3$$$                   
                    :% 4                         J$$$N                  
                    $  :F                       :$$$$$                  
                   4F  9                       J$$$$$$$                 
                   4$   k             4$$$$bed$$$$$$$$$                 
                   $$r  'F            $$$$$$$$$$$$$$$$$r                
                   $$$   b.           $$$$$$$$$$$$$$$$$N                
                   $$$$$k 3eeed$$b    XARD777."$$$$$$$$$                
    .@$**N.        $$$$$" $$$$$$F'L $$$$$$$$$$$  $$$$$$$                
    :$$L  'L       $$$$$ 4$$$$$$  * $$$$$$$$$$F  $$$$$$F         edNc   
   @$$$$N  ^k      $$$$$  3$$$$*%   $F4$$$$$$$   $$$$$"        d"  z$N  
   $$$$$$   ^k     '$$$"   #$$$F   .$  $$$$$c.u@$$$          J"  @$$$$r 
   $$$$$$$b   *u    ^$L            $$  $$$$$$$$$$$$u@       $$  d$$$$$$ 
    ^$$$$$$.    "NL   "N. z@*     $$$  $$$$$$$$$$$$$P      $P  d$$$$$$$ 
       ^"*$$$$b   '*L   9$E      4$$$  d$$$$$$$$$$$"     d*   J$$$$$r   
            ^$$$$u  '$.  $$$L     "#" d$$$$$$".@$$    .@$"  z$$$$*"     
              ^$$$$. ^$N.3$$$       4u$$$$$$$ 4$$$  u$*" z$$$"          
                '*$$$$$$$$ *$b      J$$$$$$$b u$$P $"  d$$P             
                   #$$$$$$ 4$ 3*$"$*$ $"$'c@@$$$$ .u@$$$P               
                     "$$$$  ""F~$ $uNr$$$^&J$$$$F $$$$#                 
                       "$$    "$$$bd$.TZUMAN$$$$F $$"                   
                         ?k         ?$$$$$$$$$$$F'*                     
                          9$$bL     z$$$$$$$$$$$F                       
                           $$$$    $$$$$$$$$$$$$                        
                            '#$$c  '$$$$$$$$$"                          
                             .@"#$$$$$$$$$$$$b                          
                           z*      $$$$$$$$$$$$N.                       
                         e"      z$$"  #$$$k  '*$$.                     
                     .u*      u@$P"      '#$$c   "$$c                   
              u@$*"""       d$$"            "$$$u  ^*$$b.               
            :$F           J$P"                ^$$$c   '"$$$$$$bL        
           d$$  ..      @$#                      #$$b         '#$       
           #ISMAEL#   4$$                          ^$$k         '$      
            "$$6""$b u$$                             '$    d$$$$$P      
              '$F $$$$$"                              ^b  ^$$$$b$       
               '$W$$$$"                                'b@$$$$"         
                                                        ^$$$*  
*/     

